;------------------------------------
; RobotBob's (Eric Asbell) 
; Accesing COM from RosAsm example #1
; For IActiveDesktop
; This requires IE 4.0 or greater, 
; because ActiveDesktop is a feature
; introduced by it.
;------------------------------------

; MSDN Quote:
; Overview of the Active Desktop Interface
; The Active Desktop is a feature of Microsoft Internet Explorer 4.0 that 
; allows you to include HTML documents and items (such as ActiveX  Controls and 
; Java applets) directly to your desktop. The IActiveDesktop interface, which is 
; part of the Windows Shell API, is used to programmatically add, remove, and modify 
; the items on the desktop. Active Desktop items can also be added using a Channel 
; Definition Format (CDF) file. For information about creating Active Desktop items 
; and adding them with a CDF file, see Creating Active Desktop Items. For more information 
; on CDF files, see Creating Active Channels for Internet Explorer 4.0. 


; Macros
[push | push #1 | #+1]  
[pop | pop #1 | #+1]     
[call | push #L>2 | call #1]

; Calling Com Macro!
; Example :  iCall FunctionEquate ObjectPointer &NULL DDSURFACEDESC DDLOCK_WAIT &NULL
; So the First parameter to iCall is the FunctionEquate From its interface.
; the second parameter is the Object pointer (vtable) 
; the rest of the parameters are the ones to the function you are calling!
[iCall | mov edx #2 | mov edx D$edx | push #L>3 | push #2 | call D$edx+#1 ]

; GUIDS
       
[CLSID_ActiveDesktop:
cData1: D$ 075048700H
cData2: W$ 0EF1FH
cData3: W$ 011D0H]
[cData4: B$ 098 088 000 060 097 0DE 0AC 0F9]
   
[sIID_IActiveDesktop: B$ 0 0EB 090 0F4 040 012 0D1 011 098 088 0 060 097 0DE 0AC 0F9]

; Object Pointer                                     
[psl: D$ 0]

; Parameters
[cchWallpaper: D$ 0104]
[wszWallpaper: W$ 0 #&MAX_PATH]
[szWallPaper: B$ 0 #&MAX_PATH]
[ComExampleA: B$ 'COM Example IActiveDesktop' 0]

; IActiveDesktop Interface Displacements
[QueryInterface             0
 AddRef                     4
 Release                    8
 ApplyChanges               12
 GetWallpaper               16
 SetWallpaper               20
 GetWallpaperOptions        24               
 SetWallpaperOptions        28
 GetPattern                 32
 SetPattern                 36
 GetDesktopItemOptions      40
 SetDesktopItemOptions      44
 AddDesktopItem             48
 AddDesktopItemWithUI       52
 ModifyDesktopItem          56
 RemoveDesktopItem          60
 GetDesktopItemCount        64
 GetDesktopItem             68
 GetDesktopItemByID         72
 GenerateDesktopItemHtml    76
 AddUrl                     80
 GetDesktopItemBySource     84]

; For SetWallpaperOptions
; Choose from these wonderful styles
; &WPSTYLE_CENTER 
; &WPSTYLE_TILE 
; &WPSTYLE_STRETCH 
; &WPSTYLE_MAX 

; Now this is a wacky structure
; the first dword specifies the size of the structure and the second holds 0-3
; the first is always 8=2*dword,but if it wasnt there this would just be a dword, crazy m$.
[WALLPAPEROPT:
 dwSize: D$ 8
 dwStyle: D$ &WPSTYLE_TILE ]
 
Main:
        ; Intialize OLE32
        call 'OLE32.CoInitializeEx' &NULL &COINIT_APARTMENTTHREADED
 
        ; Create a single instance and get a object pointer to a vtable                         
        call 'OLE32.CoCreateInstance' CLSID_ActiveDesktop &NULL, 
                                     &CLSCTX_INPROC_SERVER, 
                                     sIID_IActiveDesktop psl
        
        ; Lets make sure it was successful, because calling a null pointer can be hazardous!
        cmp eax &S_OK | jne L9>>
        
        ; Now Lets use IActiveDesktop!!!
        
        ; Get the full path to the current wallpaper, it will return an empty string if there is not a wallpaper.                    
        iCall GetWallpaper D$psl wszWallpaper D$cchWallpaper 00
        
        ; Set the WallPaper style
        iCall SetWallpaperOptions D$psl WALLPAPEROPT 0
        
        ; This must be called or none of your IActiveDesktop -changes- will not occur.
        iCall ApplyChanges D$psl &AD_APPLY_ALL
               
        ; Then Call release
        iCall Release D$psl 
                 
        ; We are converting the unicode string returned by GetWallPaper to Ansi
        call 'KERNEL32.WideCharToMultiByte' &CP_ACP 0 wszWallpaper 255 szWallPaper &MAX_PATH &NULL &NULL
                
        call 'USER32.MessageBoxA' 0 szWallPaper ComExampleA 0                                    
        
L9:                                                                   
        call 'OLE32.CoUninitialize'       
        call 'KERNEL32.ExitProcess' 0
        
        ret


